/* Najprej definiramo stevilo korakov, v katerih naj racuna
   po formuli. 2,000.000 je "standardno" stevilo korakov za test hitrosti.
*/

#define NOSTEPS 2000000

/* Potem nekaj pogojev ...
   Ce je definiran DEBUG, potem sproti izpisuje kaj pocne.
   VAX doloca, da prevajamo na VAX/VMS masini in ima drugace dolocen
   korak sistemskega timerja (druga simbolicna spremenljivka)
*/

/* #define DEBUG */
/* #define VAX */


/* Se enkaj konstant ... */
#define START 0.0001
#define END 1.0
#define PI 3.14159265358979323846

/* No, sedaj pa zares.... */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>

main()
{
   double x,step,res;
   long i;
   clock_t start,end;

   x=START;
   step=(END-START)/NOSTEPS;

   start=clock();

   while (1)
   {

#ifdef DEBUG
      printf ("%9e\r",x);
#endif

       if (!(x<END)) break;
       res=sin(exp(PI*log10(x)))/(pow(x,4.5)-tanh(x)+1.732*PI);
       x=x+step;
   }

   end=clock();

#ifdef VAX
   printf ("  Porabljen cas: %8.4fs\n",((double)end-start)/CLK_TCK);
#else
   printf ("  Porabljen cas: %8.4fs\n",((double)end-start)/CLOCKS_PER_SEC);
#endif

   return (0);
}


